<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

<header class="mc-header">
    <div class="mc-header-inner">
        <div class="mc-brand">
            <div class="mc-brand-lockup">
                <?php
                $logo_src = '';
                $custom_logo_id = function_exists('get_theme_mod') ? get_theme_mod('custom_logo') : 0;
                if ($custom_logo_id && function_exists('wp_get_attachment_image_url')) {
                    $logo_src = wp_get_attachment_image_url($custom_logo_id, 'full');
                }
                $site_icon = function_exists('get_site_icon_url') ? get_site_icon_url(256) : '';
                if (!$logo_src) $logo_src = $site_icon;
                if (!$logo_src && function_exists('get_stylesheet_directory_uri')) {
                    $logo_src = get_stylesheet_directory_uri() . '/assets/images/icon-10.png';
                }
                if (!$logo_src && function_exists('get_template_directory_uri')) {
                    $logo_src = get_template_directory_uri() . '/assets/images/icon-10.png';
                }
                $guest_avatar = '';
                $guest_avatar_fallback = '';
                if (function_exists('get_stylesheet_directory') && function_exists('get_stylesheet_directory_uri')) {
                    $guest_candidate = get_stylesheet_directory() . '/assets/images/post-1.jpg';
                    if (file_exists($guest_candidate)) {
                        $guest_avatar = get_stylesheet_directory_uri() . '/assets/images/post-1.jpg';
                    }
                    $fallback_candidate = get_stylesheet_directory() . '/assets/images/icon-10.png';
                    if (file_exists($fallback_candidate)) {
                        $guest_avatar_fallback = get_stylesheet_directory_uri() . '/assets/images/icon-10.png';
                    }
                }
                if ((!$guest_avatar || !$guest_avatar_fallback) && function_exists('get_template_directory') && function_exists('get_template_directory_uri')) {
                    if (!$guest_avatar) {
                        $guest_candidate = get_template_directory() . '/assets/images/post-1.jpg';
                        if (file_exists($guest_candidate)) {
                            $guest_avatar = get_template_directory_uri() . '/assets/images/post-1.jpg';
                        }
                    }
                    if (!$guest_avatar_fallback) {
                        $fallback_candidate = get_template_directory() . '/assets/images/icon-10.png';
                        if (file_exists($fallback_candidate)) {
                            $guest_avatar_fallback = get_template_directory_uri() . '/assets/images/icon-10.png';
                        }
                    }
                }
                $portal_url = '';
                $staff_portal_url = '';
                if (function_exists('moores_sentra_config')) {
                    $mc_config = moores_sentra_config();
                    $portal_url = $mc_config['portal_url'] ?? '';
                    $staff_portal_url = $mc_config['staff_portal_url'] ?? '';
                }
                ?>
                <?php
                $has_custom_logo = !empty($custom_logo_id) && !empty($logo_src);
                $has_logo_image = !empty($logo_src);
                ?>
                <a href="<?php echo esc_url(home_url('/')); ?>" class="mc-brand-link <?php echo $has_custom_logo ? 'mc-brand-link-wide' : ''; ?>" aria-label="<?php echo esc_attr(get_bloginfo('name')); ?>">
                    <?php if ($has_custom_logo) : ?>
                        <span class="mc-logo-wide" aria-hidden="true">
                            <img src="<?php echo esc_url($logo_src); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>" class="custom-logo">
                        </span>
                    <?php else : ?>
                        <span class="mc-logo-mark <?php echo $has_logo_image ? 'mc-logo-image' : ''; ?>" aria-hidden="true">
                            <?php if ($has_logo_image) : ?>
                                <img src="<?php echo esc_url($logo_src); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>" class="custom-logo">
                            <?php else : ?>
                                MC
                            <?php endif; ?>
                        </span>
                    <?php endif; ?>
                    <span class="mc-logo-text">
                        <span class="mc-logo-main">MOORE'S CUSTOMZ</span>
                        <span class="mc-logo-sub">Custom Paint & Airbrush Studio</span>
                    </span>
                </a>
            </div>
            <div class="mc-header-actions">
                <button class="mc-nav-toggle" type="button" aria-controls="mc-primary-menu" aria-expanded="false" aria-label="Open menu">
                    <span class="sr-only">Menu</span>
                    <span class="mc-nav-toggle-bars" aria-hidden="true"></span>
                </button>
                <div class="mc-account">
                    <button class="mc-account-toggle" type="button" aria-controls="mc-account-menu" aria-expanded="false" aria-label="Open account menu" data-default-avatar="<?php echo esc_attr($guest_avatar); ?>" data-default-avatar-fallback="<?php echo esc_attr($guest_avatar_fallback); ?>">
                        <span class="mc-account-avatar">
                            <img alt="" data-account-avatar hidden>
                            <span class="mc-account-fallback" aria-hidden="true">
                                <svg viewBox="0 0 32 32" focusable="false" aria-hidden="true">
                                    <path d="M16 17.5c3.4 0 6.2-2.8 6.2-6.2S19.4 5 16 5s-6.2 2.8-6.2 6.3S12.6 17.5 16 17.5zM5.5 26.5c0-4.4 5.2-6.8 10.5-6.8s10.5 2.4 10.5 6.8v1.2H5.5v-1.2z"></path>
                                </svg>
                            </span>
                        </span>
                    </button>
                    <div class="mc-account-menu" id="mc-account-menu" role="menu" hidden data-portal-url="<?php echo esc_url($portal_url); ?>" data-staff-portal-url="<?php echo esc_url($staff_portal_url); ?>" data-ajax-url="<?php echo esc_url(admin_url('admin-ajax.php')); ?>" data-nonce="<?php echo esc_attr(wp_create_nonce('moores_auth')); ?>">
                        <div class="mc-account-profile">
                            <span class="mc-account-avatar mc-account-avatar-lg">
                                <img alt="" data-account-avatar hidden>
                                <span class="mc-account-fallback" aria-hidden="true">
                                    <svg viewBox="0 0 32 32" focusable="false" aria-hidden="true">
                                        <path d="M16 17.5c3.4 0 6.2-2.8 6.2-6.2S19.4 5 16 5s-6.2 2.8-6.2 6.3S12.6 17.5 16 17.5zM5.5 26.5c0-4.4 5.2-6.8 10.5-6.8s10.5 2.4 10.5 6.8v1.2H5.5v-1.2z"></path>
                                    </svg>
                                </span>
                            </span>
                            <div class="mc-account-meta">
                                <strong data-account-name>Guest</strong>
                                <span data-account-email>Sign in to access your portal.</span>
                            </div>
                        </div>
                        <div class="mc-account-divider"></div>
                        <div class="mc-account-actions">
                            <button class="mc-account-item" type="button" data-auth-open data-account-login>Sign in</button>
                            <button class="mc-account-item" type="button" data-account-settings hidden>Account settings</button>
                            <a class="mc-account-item" href="#" data-account-client hidden>Client portal</a>
                            <a class="mc-account-item" href="#" data-account-staff hidden>Staff portal</a>
                            <button class="mc-account-item" type="button" data-account-logout hidden>Sign out</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <?php
            $home_base = function_exists('home_url') ? home_url('/') : '/';
            $services_href = (function_exists('is_front_page') && is_front_page()) ? '#services' : $home_base . '#services';
            $work_href = (function_exists('is_front_page') && is_front_page()) ? '#work' : $home_base . '#work';
        ?>
        <nav>
            <ul class="mc-menu" id="mc-primary-menu">
                <li><a href="<?php echo esc_url($services_href); ?>">Services</a></li>
                <li><a href="<?php echo esc_url($work_href); ?>">Gallery</a></li>
                <li><a href="<?php echo esc_url(function_exists('moores_request_quote_url') ? moores_request_quote_url() : home_url('/contact/')); ?>">Contact</a></li>
            </ul>
        </nav>
        
        <div class="mc-cta">
            <a href="<?php echo esc_url(function_exists('moores_request_quote_url') ? moores_request_quote_url() : home_url('/request-quote/')); ?>" class="mc-cta-primary"><span>Request Quote</span><span class="mc-cta-icon" aria-hidden="true">></span></a>
        </div>
    </div>
</header>
